<?php
	/*Database Connection*/
	include("dbconnection.php");
?>
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Header (Rows and Columns Merge)</title>
    <!-- favicon-->
	<link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">
	<link rel="icon" href="images/favicon.ico" type="image/x-icon">
    <!-- Bootstrap css-->
    <link href="assets/css/bootstrap.min.css" rel="stylesheet">      
	<!-- font-awesome css-->
    <link href="assets/css/font-awesome.min.css" rel="stylesheet"> 	
	<!-- print css-->
    <link href="assets/css/print.min.css" rel="stylesheet">    
	<!-- style -->
    <link href="style.css" rel="stylesheet">
    <!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
      <script src="assets/js/html5shiv.min.js"></script>
      <script src="assets/js/respond.min.js"></script>
    <![endif]-->
  </head>
  <body onload="window.print()">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<h2 class="print-title">Header (Rows and Columns Merge)</h2>
			</div>
		</div>
		<div class="row">
			<div class="col-md-12">
				<div class="table-responsive print-margin">
					<table id="printHtmlRowsColumnsMerge" class="table table-bordered table-hover" cellspacing="0" width="100%">
						<thead>
							<tr>
								<th rowspan="2" class="txt-center" style="width:5%; vertical-align:middle;">#</th>
								<th rowspan="2" style="width:35%; vertical-align:middle;">Row Merge</th> 
								<th colspan="2" style="width:30%;" class="txt-center">Column Merge 1</th> 
								<th colspan="2" style="width:30%;" class="txt-center">Column Merge 2</th> 
							</tr>
							<tr> 
								<th style="width:15%;">Column 2</th> 
								<th style="width:15%;">Column 3</th> 
								<th class="txt-right" style="width:15%;">Column 4</th> 
								<th class="txt-right" style="width:15%;">Column 5</th> 
							</tr>
						</thead>
						<tbody>
							<?php
								/*sql*/
								$sql = "SELECT id, ItemName, ItemCode,`Date`, Price, Quantity 
								FROM excelexport ORDER BY ItemName;";
								$result = $pdo->query($sql);
								$i=1; 
								while ($aRow = $result->fetch(PDO::FETCH_ASSOC)){
							?>
							<tr> 
								<td class="txt-center"><?php echo $i++; ?></td> 
								<td><?php echo $aRow['ItemName']; ?></td> 
								<td><?php echo $aRow['ItemCode']; ?></td> 
								<td><?php echo $aRow['Date']; ?></td> 
								<td class="txt-right"><?php echo number_format($aRow['Price'],2); ?></td> 
								<td class="txt-right"><?php echo number_format($aRow['Quantity']); ?></td> 
							</tr> 
							<?php }	?>
						</tbody>
					</table>
				</div>
			</div>
		</div>
	</div>
	
    <!-- jQuery plugins -->
    <script src="assets/js/jquery-3.2.1.min.js"></script>
    <!-- bootstrap js -->
    <script src="assets/js/bootstrap.min.js"></script>
  </body>
</html>